import requests
import json
import configparser
from Log_in import sign_in
"""
Use case 2:
This code demonstrates how to assign an Eventprofile to a sector
"""
sign_in_data = sign_in()

Token = sign_in_data[0]
url = sign_in_data[1]

payload={}
headers = {
  'Authorization': 'Bearer ' + Token
}


def name_attributes(page_url):
    response = requests.request("GET", page_url, headers=headers, data=payload)
    if response.status_code in [200]:
        for line in json.loads(response.text)["data"]:
            print("ID: " + line["id"] + "\tName: " + (line["attributes"])["name"] )
        return json.loads(response.text)["links"]
    else:
        print(response.text)
        quit()


def pagination(api_url):

    page_link = name_attributes(api_url)
    while page_link["next"] != page_link["last"]:
        page_link = name_attributes(page_link["next"])

    if(page_link["first"] != page_link["last"]):
        name_attributes(page_link["next"])


def main():
    pagination(url + "/api/1.0/locations?filter[status]=enabled")
    Location_id = input("Enter the ID of the Location you wish to use: ")
    pagination(url + "/api/1.0/locations/" + Location_id +"/sectors")
    Sector_id = input("Enter the ID of the Sector you wish to add the Event profile: ")
    pagination(url + "/api/1.0/eventprofiles")
    Event_id = input("Enter the ID of the Eventprofile you wish to use: ")

    payload = json.dumps({
      "event_profile_id": int(Event_id)
    })

    response = requests.request("POST", url + "/api/1.0/sectors/" + Sector_id + "/eventprofiles", headers=headers, data=payload)

    if response.status_code in [201]:
        print("Event profile " + Event_id + " is now associated")
    else:
        print(response.text)
        quit()

if __name__ == "__main__":
    main()
